unit grGUI;
interface
uses types, graph,wincrt;

procedure button (x,y:longint; wtext: string; active,press: boolean; view: boolean);
function  grtextread(x,y:longint; title: string; var read_str: string):boolean;


implementation
procedure button (x,y:longint; wtext: string; active,press: boolean; view: boolean);
var
   win_wid, win_hgt: integer;
   act_color,cur_color,no_act_color:integer;
begin
     win_wid := length(wtext)* 8+20;
     win_hgt := 8*2;
     no_act_color:= 23;
     act_color := blue;
     if active then cur_color:=act_color else cur_color:=no_act_color;

     if view= true then begin
          SetFillStyle(1, cur_color);
          bar (x,y,x+win_wid, y+win_hgt);
          SetFillStyle(1, black);
          bar (x+1,y+1,x+win_wid-1, y+win_hgt-1);
          if press then begin
             SetFillStyle(1, cur_color);
             bar (x+2,y+2,x+win_wid-1, y+win_hgt-1);
          end else begin
              SetFillStyle(1, cur_color);
              bar (x+1,y+1,x+win_wid-2, y+win_hgt-2);
          end;
          setcolor(white);
          outtextxy(x+10+2*ord(press),y+3+2*ord(press),wtext);
     end else begin
         SetFillStyle(1, black);
         bar (x,y,x+win_wid, y+win_hgt);
     end;
end;

const
  win_height = 35;
  win_width = 300;
  char_size_px = 8;
procedure show_window (x,y:longint; color: counter);
begin
  SetFillStyle(1, color);
  if color= black then
    bar (x,y,x+win_width,y+win_height)
  else begin
    bar  (x,y,x+win_width,y+win_height);
    SetColor(15);
    line(x,y,x,y+win_height);
    line(x,y+win_height,x+win_width, y+win_height);
    line(x+win_width, y+win_height,x+win_width, y);
    line(x+win_width, y,x, y);
    putpixel(x+1,y+1,15); putpixel(x+1,y+win_height-1,15);
    putpixel(x+win_width-1,y+1,15); putpixel(x+win_width-1,y+win_height-1,15);
    setcolor(black);
    SetFillStyle(1, white);
    bar (x+5,y+13,x+win_width-5,y+win_height-3);
  end;
end;

procedure show_cursor (x,y:longint; position:counter; color:byte);
begin
  if (position >= 0) and (position <=255) then begin
    inc(x,6);
    setcolor(color);
    line (x+char_size_px*position,y+14,x+char_size_px*position,y+win_height-4);
  end;
end;

function grtextread(x,y:longint; title: string; var read_str: string):boolean;
var
  cur: counter;
  ext_code: boolean;
  key:counter;
begin
  cur:=0;

  read_str:='';

  repeat
    show_window(x,y,8);
    outtextxy(x+2,y+1,title);
    outtextxy(x+8,y+18,read_str);
    show_cursor(x,y,cur,black);

    ext_code:=false;
    key:=ord(readkey);
    if key=0 then begin
      ext_code:=true;
      key:=ord(readkey);
    end;
    if ext_code then begin
     case key of
        75: if (cur>0) then dec(cur);
        77: if (cur*char_size_px < win_width) and (cur<length(read_str)) then inc(cur);
        83: if cur<length(read_str) then begin
            delete (read_str,cur+1,1);
           end;
     end
    end else begin
     case key of
        8: if cur>0 then begin
            delete (read_str,cur,1);
            dec(cur);
           end;
        32,45,46,48..57, 65..90,95,97..122: if not ext_code then begin
          insert(chr(key),read_str,cur+1);
          inc(cur)
        end;
     end;
    end;

  until (key=13) or (key=27);
  if key=13 then result:=true else result:=false;
  show_window(x,y,black);
end;

begin

end.
